
import java.util.Random;

public class Mazo {
	private static Random alea = new Random();
	private Carta[] mazo;
	/**
	 * numCartas indica el nmero de cartas del mazo, y se utiliza para marcar
	 * la primera posicin libre en el array mazo.
	 */
	private int numCartas;

	/**
	 * Crea una baraja de 52 cartas barajadas
	 */
	public Mazo() {
		mazo = new Carta[52];
		numCartas = 0;
		for (Carta.Valor v : Carta.Valor.values()) {
			for (Carta.Palo p : Carta.Palo.values()) {
				mazo[numCartas] = new Carta(v, p);
				numCartas++;
			}
		}
		baraja();
	}

	/**
	 * Implementa un algoritmo de barajado aleatorio. 
	 */
	public void baraja() {
		for (int i = 0; i < numCartas; i++) {
			int r = alea.nextInt(numCartas);
			Carta c = mazo[i];
			mazo[i] = mazo[r];
			mazo[r] = c;
		}
	}

	/**
	 * Devuelve el nmero de cartas que quedan en la baraja
	 */
	public int numeroCartas() {
		return numCartas;
	}

	/**
	 * Saca una carta de la baraja y la devuelve
	 * 
	 * @return Carta sacada del mazo
	 */
	public Carta daCarta() {
		if (numCartas == 0) {
			throw new RuntimeException("No hay cartas");
		}
		numCartas--;
		return mazo[numCartas];
	}
}
