
public class ManoSieteyMedia extends Mano {

	/**
	 * Las cartas 1-7 valen su valor, las cartas 8-10 no valen nada,
	 * y las cartas J,Q y K valen 0.5. La puntuacin de una mano es
	 * la suma del valor de las cartas.
	 */
	public double cuentaPuntos() {
		double puntos = 0.0;
		for (int i = 0; i < numCartas; i++) {
			if (cartas[i].valor().ordinal() <= 6) {
				puntos += cartas[i].valor().ordinal()+1;
			} else if (cartas[i].valor().ordinal() > 9) {
				puntos += 0.5;
			} // si la carta es 8, 9 o 10 la ignoramos
		}
		return puntos;
	}

}
