

public class ManoBacarra extends Mano {
	
	/**
	 * Crea una mano inicialmente vaca de tamao mximo 3.
	 */
	public ManoBacarra() {
		super(3);
	}

	/**
	 * Las cartas 1-9 valen su valor, las dems 0. La puntuacin de una mano es
	 * la suma del valor de las cartas mdulo 10.
	 */
	public double cuentaPuntos() {
		int puntos = 0;
		for (int i = 0; i < numCartas; i++) {
			if (cartas[i].valor().ordinal()+1 <= 9) {
				puntos += cartas[i].valor().ordinal()+1;
			}
		}
		return puntos % 10;
	}

	/**
	 * La mano es natural si la suma de las cartas es 8 o 9.
	 * 
	 * @return true si la mano es natural.
	 */
	public boolean esNatural() {
		double puntos = cuentaPuntos();
		return puntos == 8 || puntos == 9;
	}
}
