
public abstract class Mano {
	protected Carta[] cartas;
	/**
	 * numCartas indica el nmero de cartas de la mano, y se utiliza para marcar
	 * la primera posicin libre en el array de cartas.
	 */
	protected int numCartas;
	/**
	 * TOPE fija el tamao mximo de una mano por defecto
	 */
	static final int TOPE = 20;

	/**
	 * Crea una mano inicialmente vaca del tamao por defecto dado por la
	 * constante TOPE.
	 */
	public Mano() {
		this(TOPE);
	}

	/**
	 * Crea una mano inicialmente vaca del tamao especificado.
	 * 
	 * @param num
	 *            tamao mximo de la mano
	 */
	public Mano(int num) {
		numCartas = 0;
		cartas = new Carta[num];
	}

	/**
	 * Descarta todas las cartas de la mano, dejndola vaca.
	 */
	public void descartaTodas() {
		numCartas = 0;
	}
	/**
	 * Aade una carta a la mano.
	 * 
	 * @param c
	 *            carta que se aade a la mano
	 */
	public void agnadeCarta(Carta c) {
		if (numCartas >= cartas.length) {
			throw new RuntimeException("Mano con demasiadas cartas");
		}
		cartas[numCartas] = c;
		numCartas++;
	}

	/**
	 * Devuelve el nmero de cartas de la mano.
	 * 
	 * @return nmero de cartas de la mano
	 */
	public int numeroCartas() {
		return numCartas;
	}

	/**
	 * Devuelve la puntuacin de la mano.
	 * 
	 * @return puntuacin de la mano
	 */
	public abstract double cuentaPuntos();
	
	/**
	 * Representacin de una mano
	 * 
	 * @return Cadena de caracteres con formato: [CARTA1, CARTA2...] (ej: [TRES DE CORAZON],[TRES DE PICA])
	 */
	public String toString() {
		String s = "[";
		for (int i = 0; i < numCartas; i++) {
			s += cartas[i] + (i == numCartas - 1 ? "" : ", ");
		}
		return s + "]";
	}
}
