import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;


public class ControladorBacarra implements ActionListener{
	private VistaBacarra vistaB;
	private Mazo mazo;
	private ManoBacarra jugador, banca;
	private Carta car;
	public ControladorBacarra(VistaBacarra vistab, Mazo m, ManoBacarra j, ManoBacarra b){
		mazo = m;
		jugador = j;
		banca = b;
		vistaB = vistab;
		vistaB.habilitarInicio();
		vistaB.ok("Bienvenido al juego de Esteban");

	}
	public void actionPerformed(ActionEvent evento){
		String comando = evento.getActionCommand();
		if(comando.equals(vistaB.INICIAR)){
			vistaB.habilitarJugar(true);
			vistaB.aadirAHistorico("Se reparten las cartas...");
			car = mazo.daCarta();
			jugador.agnadeCarta(car);
			vistaB.nuevaCartaJugador(car.nombre()+".gif");
			car = mazo.daCarta();
			jugador.agnadeCarta(car);
			vistaB.nuevaCartaJugador(car.nombre()+".gif");
			car = mazo.daCarta();
			banca.agnadeCarta(car);
			vistaB.nuevaCartaBanca(car.nombre()+".gif");
			car = mazo.daCarta();
			banca.agnadeCarta(car);
			vistaB.nuevaCartaBanca(car.nombre()+".gif");
			vistaB.puntosJugador(jugador.cuentaPuntos());
			vistaB.puntosBanca(banca.cuentaPuntos());
			vistaB.ok("COMIENZA EL JUEGO!");
			if(terminar()!=-1){
				vistaB.ok("Pulse Finalizar para terminar el juego");
			}
		}
		if(comando.equals(vistaB.FINALIZAR)){
			vistaB.ok("Gracias por jugar");
			jugador.descartaTodas();
			banca.descartaTodas();
			mazo = new Mazo();
			vistaB.limpiar();
			vistaB.habilitarInicio();
			
		}
		if(comando.equals(vistaB.SE_PLANTA_J)){
			vistaB.aadirAHistorico("El jugador se planta");
			vistaB.habilitarJugador(false);
			vistaB.habilitarBanca(true);
		}
		if(comando.equals(vistaB.SE_PLANTA_B)){
			vistaB.aadirAHistorico("La banca se planta");
			myend();
			vistaB.habilitarBanca(false);
		}
		if(comando.equals(vistaB.CARTA_EXTRA_J)){
			car = mazo.daCarta();
			vistaB.nuevaCartaJugador(car.nombre()+".gif");
			vistaB.aadirAHistorico("El jugador pide una carta: "+car.toString());
			jugador.agnadeCarta(car);
			vistaB.puntosJugador(jugador.cuentaPuntos());
			vistaB.habilitarJugador(false);
			vistaB.habilitarBanca(true);
		}
		if(comando.equals(vistaB.CARTA_EXTRA_B)){
			car = mazo.daCarta();
			vistaB.nuevaCartaBanca(car.nombre()+".gif");
			vistaB.aadirAHistorico("La banca pide una carta: "+car.toString());
			banca.agnadeCarta(car);
			vistaB.puntosBanca(banca.cuentaPuntos());
			//check if mano natural again?
			myend();
			vistaB.ok("Pulse Finalizar para terminar el juego");
			vistaB.habilitarBanca(false);
		}
		
	}
	
	private int terminar(){
		if(jugador.esNatural() && !(banca.esNatural())){
			vistaB.aadirAHistorico("Gana el jugador con mano natural:");
			vistaB.aadirAHistorico(jugador.toString()+" "+jugador.cuentaPuntos()+" puntos");
			vistaB.aadirAHistorico("frente a");
			vistaB.aadirAHistorico(banca.toString()+" "+banca.cuentaPuntos()+" puntos");
			vistaB.habilitarBanca(false);
			vistaB.habilitarJugador(false);
			return 1;
		}
		if(banca.esNatural() && !(jugador.esNatural())){
			vistaB.aadirAHistorico("Gana la banca con mano natural:");
			vistaB.aadirAHistorico(banca.toString()+" "+banca.cuentaPuntos()+" puntos");
			vistaB.aadirAHistorico("frente a");
			vistaB.aadirAHistorico(jugador.toString()+" "+jugador.cuentaPuntos()+" puntos");
			vistaB.habilitarBanca(false);
			vistaB.habilitarJugador(false);
			return 2;
		}
		if(jugador.esNatural() && banca.esNatural()){
			double a = jugador.cuentaPuntos();
			double b = banca.cuentaPuntos();
			if(a == b){
				//empate
				vistaB.aadirAHistorico("Empatan con mano natural");
				vistaB.aadirAHistorico("Banca:");
				vistaB.aadirAHistorico(banca.toString()+" "+banca.cuentaPuntos()+" puntos");
				vistaB.aadirAHistorico("Jugador:");
				vistaB.aadirAHistorico(jugador.toString()+" "+jugador.cuentaPuntos()+" puntos");
				return 0;
			}
			if(a > b){
				//gana el jugador
				vistaB.aadirAHistorico("Gana el jugador con:");
				vistaB.aadirAHistorico(jugador.toString()+" "+jugador.cuentaPuntos()+" puntos");
				vistaB.aadirAHistorico("frente a");
				vistaB.aadirAHistorico(banca.toString()+" "+banca.cuentaPuntos()+" puntos");
				vistaB.habilitarBanca(false);
				vistaB.habilitarJugador(false);
				return 1;
			}
			if(a < b){
				//gana la banca
				vistaB.aadirAHistorico("Gana la banca con mano:");
				vistaB.aadirAHistorico(banca.toString()+" "+banca.cuentaPuntos()+" puntos");
				vistaB.aadirAHistorico("frente a");
				vistaB.aadirAHistorico(jugador.toString()+" "+jugador.cuentaPuntos()+" puntos");
				vistaB.habilitarBanca(false);
				vistaB.habilitarJugador(false);
				return 2;
			}
		}
		return -1;
	}
	private int myend(){
		double a = 9 - jugador.cuentaPuntos();
		double b = 9 - banca.cuentaPuntos();
		if(a == b){
			//empate
			vistaB.aadirAHistorico("Empatan con:");
			vistaB.aadirAHistorico("Banca:");
			vistaB.aadirAHistorico(banca.toString()+" "+banca.cuentaPuntos()+" puntos");
			vistaB.aadirAHistorico("Jugador:");
			vistaB.aadirAHistorico(jugador.toString()+" "+jugador.cuentaPuntos()+" puntos");
			return 0;
		}
		if(a < b){
			//gana el jugador
			vistaB.aadirAHistorico("Gana el jugador con:");
			vistaB.aadirAHistorico(jugador.toString()+" "+jugador.cuentaPuntos()+" puntos");
			vistaB.aadirAHistorico("frente a");
			vistaB.aadirAHistorico(banca.toString()+" "+banca.cuentaPuntos()+" puntos");
			return 1;
		}
		if(a > b){
			//gana la banca
			vistaB.aadirAHistorico("Gana la banca con mano:");
			vistaB.aadirAHistorico(banca.toString()+" "+banca.cuentaPuntos()+" puntos");
			vistaB.aadirAHistorico("frente a");
			vistaB.aadirAHistorico(jugador.toString()+" "+jugador.cuentaPuntos()+" puntos");
			return 2;
		}
		return -1;
	}
}
