

public class Carta {
	/**
	 * Tipo enumerado con los cuatro palos de la baraja 
	 */
	public static enum Palo {
		PICA, TREBOL, DIAMANTE, CORAZON
	};

	/**
	 * Tipo enumerado con las 13 cartas de cada palo
 	 */
	public static enum Valor {
		AS, DOS, TRES, CUATRO, CINCO, SEIS, SIETE, OCHO, NUEVE, DIEZ, J, Q, K 
	};
	
	private Valor valor;

	private Palo palo;

	/**
	 * Se construye una carta dados su valor y su palo
	 * 
	 * @param valor Valor de la carta
	 * @param palo Palo de la carta
	 */
	public Carta(Valor valor, Palo palo) {
		this.valor = valor;
		this.palo = palo;
	}

	/**
	 * Devuelve el palo de la carta
	 * 
	 * @return palo
	 */
	public Palo palo() {
		return palo;
	}

	/**
	 * Devuelve el valor de la carta
	 * 
	 * @return valor
	 */
	public Valor valor() {
		return valor;
	}

	/**
	 * Devuelve el nombre de la carta expresado en letras
	 * 
	 * @return Cadena de caracteres con formato: PALO_VALOR (ej: CORAZON_TRES)
	 */
	public String nombre(){
		return palo + "_" + valor;
	}
	
	/**
	 * Representacin de una carta
	 * 
	 * @return Cadena de caracteres con formato: [VALOR de PALO] (ej: [TRES DE CORAZON]
	 */
	public String toString() {
		return "[" + valor + " de " + palo + "]"; 
	}
}