import java.util.StringTokenizer;
import java.util.NoSuchElementException;

public class ContadorPalabras {
	protected PalabraEnTexto[] palabras;
	protected final static int size = 10;
	private int primlibre;

	public ContadorPalabras() {
		this(size);
	}

	public ContadorPalabras(int pal) {
		palabras = new PalabraEnTexto[pal];
		primlibre = 0;
	}

	private int esta(String pal) {
		PalabraEnTexto mipal = new PalabraEnTexto(pal);
		for (int i = 0; i <= primlibre-1; i++) {
			if (palabras[i]!=null && palabras[i].equals(mipal)) {
				return i;
			}
		}
		return -1;
	}

	public void incluye(String pal) {
		int i = this.esta(pal);
		if (i >= 0) {
			palabras[i].incrementa();
		} else {
			if(primlibre < palabras.length){
						palabras[primlibre] = new PalabraEnTexto(pal);
						primlibre++;
			}else{
			// duplicamos
				PalabraEnTexto[] buffer = palabras;
				palabras = new PalabraEnTexto[buffer.length * 2];
				System.arraycopy(buffer, 0, palabras, 0, buffer.length);
				palabras[buffer.length] = new PalabraEnTexto(pal);
				primlibre++;
			}
		}

	}

	public void incluyeTodas(String linea, String del) {
		StringTokenizer st = new StringTokenizer(linea, del);
		while (st.hasMoreTokens()) {
			incluye(st.nextToken());
		}
	}

	public void incluyeTodas(String[] texto, String del) {
		for (int x = 0; x < texto.length; x++) {
			incluyeTodas(texto[x], del);
		}
	}

	public PalabraEnTexto encuentra(String pal) throws NoSuchElementException {
		int i = esta(pal);
		if (i == -1) {
			throw new NoSuchElementException("Such word may not exist: " + pal);
		} else {
			return palabras[i];
		}
	}

	public String toString() {
		StringBuilder mybuilder = new StringBuilder();
		mybuilder.append("[");
		for (int x = 0; x < primlibre-2; x++) {
			mybuilder.append(palabras[x].toString());
			mybuilder.append(", ");
		}
		if(primlibre > 0){
			mybuilder.append(palabras[primlibre -1].toString()).append("]");
		}else{
			mybuilder.append("]");
		}
		return mybuilder.toString();
	}
}
